
SELECT * FROM NOTAS_FISCAIS NF
INNER JOIN ITENS_NOTAS_FISCAIS INF
ON NF.NUMERO = INF.NUMERO;

SELECT NF.CPF, NF.DATA_VENDA, INF.QUANTIDADE FROM NOTAS_FISCAIS NF
INNER JOIN ITENS_NOTAS_FISCAIS INF
ON NF.NUMERO = INF.NUMERO;

SELECT NF.CPF, TO_CHAR(NF.DATA_VENDA, 'YYYY-MM') AS MES_ANO
, INF.QUANTIDADE FROM NOTAS_FISCAIS NF
INNER JOIN ITENS_NOTAS_FISCAIS INF
ON NF.NUMERO = INF.NUMERO;

SELECT NF.CPF, TO_CHAR(NF.DATA_VENDA, 'YYYY-MM') AS MES_ANO
, SUM(INF.QUANTIDADE) AS VOLUME_VENDIDO FROM NOTAS_FISCAIS NF
INNER JOIN ITENS_NOTAS_FISCAIS INF
ON NF.NUMERO = INF.NUMERO
GROUP BY NF.CPF, TO_CHAR(NF.DATA_VENDA, 'YYYY-MM');

SELECT * FROM TABELA_DE_CLIENTES;

SELECT CPF, NOME, VOLUME_DE_COMPRA FROM TABELA_DE_CLIENTES;

SELECT CADASTRO.CPF, CADASTRO.NOME, VENDAS.MES_ANO, CADASTRO.VOLUME_DE_COMPRA, 
VENDAS.VOLUME_VENDIDO FROM
(SELECT NF.CPF, TO_CHAR(NF.DATA_VENDA, 'YYYY-MM') AS MES_ANO
, SUM(INF.QUANTIDADE) AS VOLUME_VENDIDO FROM NOTAS_FISCAIS NF
INNER JOIN ITENS_NOTAS_FISCAIS INF
ON NF.NUMERO = INF.NUMERO
GROUP BY NF.CPF, TO_CHAR(NF.DATA_VENDA, 'YYYY-MM')) VENDAS
INNER JOIN
(SELECT CPF, NOME, VOLUME_DE_COMPRA FROM TABELA_DE_CLIENTES) CADASTRO
ON VENDAS.CPF = CADASTRO.CPF;

SELECT CADASTRO.CPF, CADASTRO.NOME, VENDAS.MES_ANO, CADASTRO.VOLUME_DE_COMPRA, 
VENDAS.VOLUME_VENDIDO AS VOLUME_LIMITE,
CASE WHEN CADASTRO.VOLUME_DE_COMPRA <= VENDAS.VOLUME_VENDIDO THEN 'Vendas Vlidas'
ELSE 'Vendas Invlidas' END AS RESULTADO
FROM
(SELECT NF.CPF, TO_CHAR(NF.DATA_VENDA, 'YYYY-MM') AS MES_ANO
, SUM(INF.QUANTIDADE) AS VOLUME_VENDIDO FROM NOTAS_FISCAIS NF
INNER JOIN ITENS_NOTAS_FISCAIS INF
ON NF.NUMERO = INF.NUMERO
GROUP BY NF.CPF, TO_CHAR(NF.DATA_VENDA, 'YYYY-MM')) VENDAS
INNER JOIN
(SELECT CPF, NOME, VOLUME_DE_COMPRA FROM TABELA_DE_CLIENTES) CADASTRO
ON VENDAS.CPF = CADASTRO.CPF
WHERE VENDAS.MES_ANO = '2018-01';






